// ------------------------------------
//       OnBoardC DB Library
//            Version 1.01
//    by: Harry Konstas May.19/2000
// ------------------------------------
 
#include "OBL.h"
 
void DeleteDB(char *name)
{

  LocalID id;
  DmOpenRef db;

  id=DmFindDatabase(0,name);
  if(id) DmDeleteDatabase(0,id);

}

DmOpenRef NewDB(char *fname,ULong creator,ULong type)
{

  int err;
  DmOpenRef db;
  LocalID id;
  UInt attr;

  DeleteDB(fname);

  err= DmCreateDatabase(0,fname,creator,type,false);

  if(err==0) {
    id = DmFindDatabase(0,fname);

    DmDatabaseInfo(0,id,NULL,&attr,NULL,NULL,
      NULL,NULL,NULL,NULL,NULL,NULL,NULL);

    attr=attr|0x008; // set backup bit
    DmSetDatabaseInfo(0,id,NULL,&attr,NULL,NULL,
      NULL,NULL,NULL,NULL,NULL,NULL,NULL);
    
    db = DmOpenDatabase(0,id,dmModeReadWrite);

    return db;
  }

  return NULL;

}

DmOpenRef OpenDB(char *fname)
{

  int err;
  DmOpenRef db;
  LocalID id;

  id=DmFindDatabase(0,fname);
  if(id) db = DmOpenDatabase(0,id,dmModeReadWrite);
  else return NULL;

  return db;

}

int RenameDB(char *oldname, char *newname)
{

  LocalID id,id2;
  UInt Attr=0x0008; // backup bit

  id=DmFindDatabase(0,oldname);
  id2=DmFindDatabase(0,newname);

  if(id!=0&&id2==0) {
    DmSetDatabaseInfo(0,id,newname, &Attr, NULL, NULL, NULL, NULL, NULL, NULL,NULL, NULL, NULL);
    return 1;
  }
  return 0;
}

void CloseDB(DmOpenRef db)
{

  DmCloseDatabase(db);

}
